<?php
class tsweb_options_page{
	//data members:
	var $options;
	var $file_name;
	var $page_title;
	
	//constructor:	
	function tsweb_options_page($info, $options){
	$this->info=$info;
	$this->file_name=$info['pagename']; //filename for the options page
	$this->page_title=$info['title']; //title, displayed near top of page
	$this->options=$options;
	
	add_action('admin_menu', array(&$this, 'tsweb_add_menu'));	
	}

	//Add menu item
	function tsweb_add_menu(){

		if(!$this->info['sublevel']){
			add_menu_page(TSWEB_THEME, TSWEB_THEME, 'administrator', $this->file_name, array(&$this, 'tsweb_generate_page'), get_bloginfo('template_directory').'/functions/img/icon.png'); 
		}
		else{			
			add_submenu_page(TSWEB_MAINMENU_NAME, $this->page_title, $this->page_title, 'administrator', $this->file_name, array(&$this, 'tsweb_generate_page'));
		}
	}
	//Generate functions page
	function tsweb_generate_page(){
		$this->save_options();
?>
	<form method="post" id="tsweb_options_form" class="tsweb_options_form">
		<div class="tsweb_section">
			<div class="tsweb_title clearfix">
					<div class="tsweb_title_image clearfix">
						<a id="logo-framework" target="_blank" href="http://2sweb.ir" title="توس وب؛ طراحی حرفه ای سایت و قالب وردپرس">طراحی سایت توس وب</a>
            <h6 id="slogan-framework">به کیفیت و مشتری مداری می اندیشیم ...</h6>
			<div class="tsweb_meta">
				<div>پنل مدیریتی قالب <?php echo TSWEB_OPTIONS; ?></div>
				<div><a href="<?php echo TSWEB_THEME_DOCS; ?>" target="_blank">دانلود فایل آموزشی</a> <a href="http://support.2sweb.ir/">ارسال تیکت</a></div>
			</div><!--.tsweb_meta -->
					</div><!--.tsweb_title_image -->

					<div class="tsweb_title_text">
						<h3><?php echo $this->page_title; ?></h3>
					</div><!--.tsweb_title_text -->
			</div><!--.tsweb_title -->

			<div class="tsweb_options">
<?php
		foreach ($this->options as $value){
		
			switch ( $value['type'] ){
				
				case "text": $this->display_text($value); break;
				
				case "color": $this->display_color($value); break;
				
				case "textarea": $this->display_textarea($value); break;
				
				case "codearea": $this->display_codearea($value); break;
				
				case "image": $this->display_image($value); break;
				
				case "checkbox": $this->display_checkbox($value); break;
				
				case "checkbox-nav": $this->display_checkbox_nav($value); break;
				
				case "radio": $this->display_radio($value); break;
				
				case "select": $this->display_select($value); break;

				case "reset-options": $this->display_reset($value); break;
			}			
		}
?>
			<?php if($value['type']!="reset-options") { ?>
				<div class="tsweb_input tsweb_save clearfix">						
					<div class="label">ذخیره ی تنظیمات</div>
					<div class="option_wrap">
						<div class="option_control">
							<input type="hidden" name="save-action" value="save changes" />						
							<input type="submit" class="button" id="final_submit" value="ذخیره تنظیمات" />
						</div>
						<div class="description">جهت اعمال هرگونه تغییرات انجام شده، کلیک کنید:</div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_save -->
			<?php } ?>
			</div><!--.tsweb_options -->
		</div><!--.tsweb_section -->
	</form><!--.save form-->
<?php
	}
	
	function display_text($value){
?>
				<div class="tsweb_input tsweb_text clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>		
					<div class="option_wrap">
						<div class="option_control">
							<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if(get_option($value['id'])) echo stripslashes(htmlspecialchars(get_option($value['id'])));else echo $value['default']; ?>" />
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_text -->
<?php
	}
	function display_color($value){
?>
				<div class="tsweb_input tsweb_text clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>		
					<div class="option_wrap">
						<div class="option_control">
							<input class="color" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php if(get_option($value['id'])) echo stripslashes(htmlspecialchars(get_option($value['id'])));else echo $value['default']; ?>" />
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_text -->
<?php
	}
	function display_textarea($value){
?>
				<div class="tsweb_input tsweb_textarea clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>
					<div class="option_wrap">
						<div class="option_control">
							<textarea rows="5" cols="25" id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>"><?php
							if(get_option($value['id'])) 
								echo stripslashes(htmlspecialchars($prefix.get_option($value['id'])));
							else 
								echo $value['default']; 
							?></textarea>
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_textarea -->
<?php
	}

	function display_codearea($value){
?>
				<div class="tsweb_input tsweb_textarea clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>
					<div class="option_wrap">
						<div class="option_control">
							<textarea class="codearea" rows="5" cols="25" id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>"><?php
							if(get_option($value['id'])) 
								echo stripslashes(htmlspecialchars($prefix.get_option($value['id'])));
							else 
								echo $value['default']; 
							?></textarea>
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_textarea -->
<?php
	}

	function display_image($value){
?>
				<div class="tsweb_input tsweb_image clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>	
					<div class="option_wrap">
						<div class="option_control">
							<input type="text" value="<?php 
							if(get_option($value['id'])) echo stripslashes(get_option($value['id']));
						else 
							echo $value['default']; 
						?>" name="<?php echo $value['id']; ?>"/>
                        <div style="height:1px; clear:both;"></div>
							<span id="<?php echo $value['id']; ?>" class="button upload tsweb_upload">آپلود عکس</span>
							<?php if(get_option($value['id'])) :?>
								<span class="button tsweb_remove" id="remove_<?php echo $value['id']; ?>">حذف عکس</span>
							<?php endif; ?>						
							<div class="tsweb_image_preview">
								<?php if(get_option($value['id'])):?>
								<img src="<?php echo get_option($value['id']); ?>" />
								<?php elseif($value['default'] != ""):?>
								<img src="<?php echo $value['default']; ?>" />
								<?php endif; ?>
							</div><!--.tsweb_image_preview-->
						</div><!--.option_control-->
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_input -->
<?php
	}
	function display_checkbox($value){
?>
				<div class="tsweb_input tsweb_checkbox clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>
					<div class="option_wrap">
						<div class="option_control">
						<?php
						$ctr=-1;
						foreach($value['options'] as $cb_option):
							$ctr++;
							$checked='';
							if(get_option($prefix.$value['id'][$ctr])){
								if(get_option($prefix.$value['id'][$ctr]) == 'true') $checked=' checked="checked"';
								else $checked='';
							}
							else{
								if($value['default'][$ctr]=="checked") $checked=' checked="checked"';
							}
					?>	
							<input type="checkbox" id="<?php echo $value['id'][$ctr]; ?>"<?php echo $checked; ?> name="<?php echo $value['id'][$ctr]; ?>"><label for="<?php echo $value['id'][$ctr]; ?>"><?php echo $value['options'][$ctr]; ?></label><br/>
					<?php
						endforeach;
					?>
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>

					</div><!--.option_wrap -->
				</div><!--.tsweb_checkbox -->
<?php
	}
		function display_checkbox_nav($value){
?>
				<div class="tsweb_input tsweb_checkbox_nav clearfix">						
					<div class="label"><?php echo $value['name']; ?></div>
					<div class="option_wrap">
						<div class="option_control">
						<?php
						$ctr=-1;
						foreach($value['options'] as $cb_option):
							$ctr++;
							$checked='';
							if(get_option($prefix.$value['id'][$ctr])){
								if(get_option($prefix.$value['id'][$ctr]) == 'true') $checked=' checked="checked"';
								else $checked='';
							}
							else{
								if($value['default'][$ctr]=="checked") $checked=' checked="checked"';
							}
							$clearfix='';
							if($ctr%3==0 and $ctr!=0)
								$clearfix= ' style="clear:both"';	
							$last='';
							if(($ctr+1)%3==0 )
								$last=' last';
					?>	
							<div class="checkbox-nav<?php echo $last; ?>"<?php echo $clearfix; ?>>
								<input class="tsweb_super_check" type="checkbox" id="<?php echo $value['id'][$ctr]; ?>"<?php echo $checked; ?> name="<?php echo $value['id'][$ctr]; ?>"><label for="<?php echo $value['id'][$ctr]; ?>"><?php echo $value['options'][$ctr]; ?></label>
							</div>
					<?php
						endforeach;
					?>
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_checkbox -->
<?php
	}
	function display_radio($value){
?>
				<div class="tsweb_input tsweb_radio clearfix">		
					<div class="label"><?php echo $value['name']; ?></div>
					<div class="option_wrap">
						<div class="option_control">
						<?php
						$ctr=-1;
						if(get_option($value['id'])) $default=get_option($value['id']);
						else $default = $value['default'];
						foreach($value['options'] as $rd_option):
							$ctr++;
							$checked='';
							if($value['values'][$ctr]==$default) $checked=' checked="checked"';	
					?>
							<input type="radio" id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>" value="<?php echo $value['values'][$ctr]; ?>"<?php echo $checked; ?>><label for="<?php echo $value['id']; ?>"><?php echo $value['options'][$ctr]; ?></label><br/>
					<?php
						endforeach;
					?>
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_radio -->
<?php
	}
	function display_select($value){
?>			
				<div class="tsweb_input tsweb_select clearfix">		
					<div class="label"><?php echo $value['name']; ?></div>
					<div class="option_wrap">
						<div class="option_control">						
							<select id="<?php echo $value['id']; ?>" name="<?php echo $value['id']; ?>">
						<?php
							if(get_option($value['id'])) $default=get_option($value['id']);
							else $default = $value['default'];
							
							foreach($value['options'] as $sel_opt):								
								$selected='';							
								if($sel_opt == $default) $selected=' selected="selected"';
						?>						
								<option <?php echo $selected;?>><?php echo $sel_opt; ?></option>						
						<?php
							endforeach;
						?>
							</select>
						</div>
						<div class="description"><?php echo $value['desc']; ?></div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_select -->
<?php
	}
	
	function display_reset(){
	?>
				<div class="tsweb_input tsweb_save clearfix">						
					<div class="label">بازگردانی تنظیمات</div>
					<div class="option_wrap">
						<div class="option_control">						
							<input type="hidden" class="button" id="final_submit" name="reset-action" value="reset options" />
							<input type="submit" class="button" id="final_submit" value="پاک کردن تنظیمات" />
						</div>
						<div class="description">در صورت تمایل به بازگردانی تمام تنظیمات به حالت اولیه، کلیک کنید:</div>
					</div><!--.option_wrap -->
				</div><!--.tsweb_save -->
	<?php
	}
	
	function save_options(){
		if (isset($_POST['save-action']) && $_POST['save-action'] == 'save changes' && $_POST['reset-action']!="reset options" ) {
							foreach ($this->options as $value) {
								$the_type=$value['type'];
									if($the_type=="checkbox" or $the_type=="checkbox-nav"){
										$ctr=0;
										foreach( $value['options'] as $cbopt):
											$curr_id=$value['id'][$ctr];
											if(isset($_POST[$curr_id]))
												update_option($curr_id, 'true');
											else
												update_option($curr_id, 'false');
										$ctr++;
										endforeach;
									}
									if($the_type!="checkbox" and $the_type!="checkbox-nav"){
										update_option($value['id'], $_POST[ $value['id'] ]);
									}
							}
					echo '<div id="message" class="updated fade"><p><strong>تنظیمات قالب '.TSWEB_THEME.' ذخیره شد.</strong></p></div>';
					} else if (isset($_POST['reset-action']) && $_POST['reset-action'] == 'reset options' ) {
					global $wpdb; //Access to the Wordpress Database
					$query = "DELETE FROM $wpdb->options WHERE option_name LIKE 'tsweb_%'";
					$wpdb->query($query);
					echo '<div id="message" class="updated fade"><p><strong>تمام تنظیمات '.TSWEB_THEME.' به حالت اولیه بازگردانده شد. حالا میتوانید با کلیک روی دکمه ی <span style="color:red;">ذخیره تنظیمات</span> تنظیمات اولیه را ذخیره کنید.</strong></p></div>';
					}
	}
}//end class
?>