<?php
class tsweb_dynamic_text_ads_options{

	//data members:
	var $file_name;
	var $page_title;
	var $text_ads_name;
	var $link_name;
	var $title_name;
	var $text_name;
	var $expire_name;

	//constructor:	
	function tsweb_dynamic_text_ads_options($info){

	$this->info=$info;
	$this->file_name=$info['pagename']; //filename for the options page
	$this->page_title=$info['title']; //title, displayed near top of page
	$this->text_ads_name=$info['text_ads_name'];
	$this->link_name=$info['link_name'];
	$this->title_name=$info['title_name'];
	$this->text_name=$info['text_name'];
	$this->expire_name=$info['expire_name'];

	add_action('admin_menu', array(&$this, 'tsweb_add_menu'));

	}

	//Add menu item
	function tsweb_add_menu(){
			add_submenu_page(TSWEB_MAINMENU_NAME, $this->page_title, $this->page_title, 'administrator', $this->file_name, array(&$this, 'tsweb_generate_page'));
	}

	//Generate functions page
	function tsweb_generate_page(){
		$this->save_options();

?>
<form method="post" id="tsweb_options_form" class="tsweb_options_form">
<div class="tsweb_title clearfix">
		<div class="tsweb_title_image clearfix">
			<a id="logo-framework" target="_blank" href="http://2sweb.ir" title="توس وب؛ طراحی حرفه ای سایت و قالب وردپرس">طراحی سایت توس وب</a>
            <h6 id="slogan-framework">به کیفیت و مشتری مداری می اندیشیم ...</h6>
			<div class="tsweb_meta">
				<div>پنل مدیریتی قالب <?php echo TSWEB_OPTIONS; ?></div>
				<div><a href="<?php echo TSWEB_THEME_DOCS; ?>" target="_blank">دانلود فایل آموزشی</a> <a href="http://support.2sweb.ir/">ارسال تیکت</a></div>
			</div><!--.tsweb_meta -->
		</div><!--.tsweb_title_image -->
		<div class="tsweb_title_text">
			<h3><?php echo $this->page_title; ?></h3>
		</div><!--.tsweb_title_text -->
</div><!--.tsweb_title -->
	<input type="hidden" name="action" id="action" value="tsweb_save_text_ads" />
	<table class="widefat tsweb_ads tsweb_options">
		<thead>
			<tr>
				<th>لینک تبلیغ</th>
				<th>متن</th>
				<th>توضیح</th>
				<th class="aligncenter">تاریخ انقضا</th>
				<th>کنترلها</th>
			</tr>
		</thead>
		<tbody>
<?php

	$link_set = get_option($this->link_name);
	$text_set = get_option($this->text_name);
	$title_set = get_option($this->title_name);
	$expire_set = get_option($this->expire_name);

	$ads_empty = false;

	if($link_set==false or count($link_set)==0)
		$ads_empty = true;

	if($ads_empty){ //if there are no options associated with the ads, display one input box

?>

			<tr class="empty">
				<td>
					<input type="text" name="<?php echo $this->text_ads_name; ?>[link][]" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->text_ads_name; ?>[text][]" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->text_ads_name; ?>[title][]" />
				</td>
				<td>
					<input class="mini-input date-input" type="text" name="<?php echo $this->text_ads_name; ?>[expire][]" />
				</td>
				<td>
					<input title="<?php echo $this->text_ads_name;?>" type="button" class="button add-text-ads-above" value="افزودن به بالا" /><br />
					<input type="button" class="button-primary delete-text-ads-item" value="حذف" /><br />
					<input title="<?php echo $this->text_ads_name;?>" type="button" class="button add-text-ads-below" value="افزودن به پایین" /><br />
				</td>
			</tr>
<?php
	} else {
	//Otherwise=>if there is atleast one ads image, display the set of images and links

		$count=0;
		foreach($link_set as $item_link):
			$item_link = $link_set[$count];
			$item_text = $text_set[$count];
			$item_title = $title_set[$count];
			$item_expire = $expire_set[$count];
			$count++;

?>
			<tr>
				<td>
					<input type="text" name="<?php echo $this->text_ads_name; ?>[link][]" value="<?php echo $item_link; ?>" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->text_ads_name; ?>[text][]" value="<?php echo $item_text; ?>" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->text_ads_name; ?>[title][]" value="<?php echo $item_title; ?>" />
				</td>
				<td>
					<input class="mini-input date-input" type="text" name="<?php echo $this->text_ads_name; ?>[expire][]" value="<?php echo $item_expire; ?>" />
				</td>
				<td>
					<input title="<?php echo $this->text_ads_name;?>" type="button" class="button add-text-ads-above" value="افزودن به بالا" /><br />
					<input type="button" class="button-primary delete-text-ads-item" value="حذف" /><br />
					<input title="<?php echo $this->text_ads_name;?>" type="button" class="button add-text-ads-below" value="افزودن به پایین" /><br />
				</td>
			</tr>
<?php
		endforeach;
		}
?>
		</tbody>
	</table>

	<input type="submit" class="button" id="final_submit" name="final_submit" value="ذخیره تنظیمات" />
</form>
<?php
	
	}

function save_options(){

	if (isset($_POST['action']) && $_POST['action'] == 'tsweb_save_text_ads' ) {
						$posted_ads = $_POST[$this->text_ads_name];
						$posted_links = $posted_ads['link'];
						$posted_texts = $posted_ads['text'];
						$posted_titles = $posted_ads['title'];
						$posted_expires = $posted_ads['expire'];

						update_option($this->link_name, $posted_links);
						update_option($this->text_name, $posted_texts);
						update_option($this->title_name, $posted_titles);
						update_option($this->expire_name, $posted_expires);

				echo '<div id="message" class="updated fade"><p><strong>تنظیمات قالب '.TSWEB_THEME.' ذخیره شد.</strong></p></div>';
	}
}
}//end class
?>