<?php
class tsweb_dynamic_slider_options{

	//data members:
	var $file_name;
	var $page_title;
	var $slider_name;
	var $image_name;
	var $link_name;
	var $title_name;
	var $caption_name;
	
	//constructor:	
	function tsweb_dynamic_slider_options($info){
	$this->info=$info;
	$this->file_name=$info['pagename']; //filename for the options page
	$this->page_title=$info['title']; //title, displayed near top of page
	$this->slider_name=$info['slider_name'];
	$this->image_name=$info['image_name'];
	$this->link_name=$info['link_name'];
	$this->title_name=$info['title_name'];
	$this->caption_name=$info['caption_name'];
	
	add_action('admin_menu', array(&$this, 'tsweb_add_menu'));
	
	}
	
	//Add menu item
	function tsweb_add_menu(){
			add_submenu_page(TSWEB_MAINMENU_NAME, $this->page_title, $this->page_title, 'administrator', $this->file_name, array(&$this, 'tsweb_generate_page'));
	}
		
	//Generate functions page
	function tsweb_generate_page(){
		$this->save_options();

?>
<form method="post" id="tsweb_options_form" class="tsweb_options_form">
<div class="tsweb_title clearfix tsweb-ads-title">
		<div class="tsweb_title_image clearfix">
			<a id="logo-framework" target="_blank" href="http://2sweb.ir" title="توس وب؛ طراحی حرفه ای سایت و قالب وردپرس">طراحی سایت توس وب</a>
            <h6 id="slogan-framework">به کیفیت و مشتری مداری می اندیشیم ...</h6>
			<div class="tsweb_meta">
				<div>پنل مدیریتی قالب <?php echo TSWEB_OPTIONS; ?></div>
				<div><a href="<?php echo TSWEB_THEME_DOCS; ?>" target="_blank">دانلود فایل آموزشی</a> <a href="http://support.2sweb.ir/">ارسال تیکت</a></div>
			</div><!--.tsweb_meta -->
		</div><!--.tsweb_title_image -->
		<div class="tsweb_title_text">
			<h3><?php echo $this->page_title; ?></h3>
		</div><!--.tsweb_title_text -->
</div><!--.tsweb_title -->
<input type="hidden" name="action" id="action" value="tsweb_save_slider" />
	<table class="widefat tsweb_slider tsweb_options">
		<thead>
			<tr>
				<th>آدرس عکس</th>
				<th>لینک (اختیاری)</th>
				<th>عنوان</th>
				<th>متن کوتاه (کپشن - caption)</th>
				<th>کنترل ها</th>
			</tr>
		</thead>
		
		<tbody>

<?php
	
	$image_set = get_option($this->image_name);
	$link_set = get_option($this->link_name);
	$title_set = get_option($this->title_name);
	$caption_set = get_option($this->caption_name);
	
	$slider_empty = false;
	
	if($image_set==false or count($image_set)==0)
		$slider_empty=true;
		
	if($slider_empty){ //if there are no options associated with the slider, display one input box
			
?>

			<tr class="empty">
				<td>
					<input type="text" name="<?php echo $this->slider_name; ?>[image][]" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->slider_name; ?>[link][]" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->slider_name; ?>[title][]" />
				</td>
				<td>
					<textarea name="<?php echo $this->slider_name; ?>[caption][]"></textarea>
				</td>
				<td>
					<input title="<?php echo $this->slider_name;?>" type="button" class="button add-slider-above" value="افزودن به بالا" /><br />
					<input type="button" class="button-primary delete-slider-item" value="حذف" /><br />	
					<input title="<?php echo $this->slider_name;?>" type="button" class="button add-slider-below" value="افزودن به پایین" /><br />
				</td>
			</tr>
<?php
	} else {//Otherwise=>if there is atleast one slider image, display the set of images and links
	
		$count=0;
		foreach($image_set as $item_image):
			$item_link = $link_set[$count];
			$item_title = $title_set[$count];
			$item_caption = $caption_set[$count];
			$count++;

?>
			<tr>
				<td>
					<input type="text" name="<?php echo $this->slider_name; ?>[image][]" value="<?php echo $item_image; ?>" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->slider_name; ?>[link][]" value="<?php echo $item_link; ?>" />
				</td>
				<td>
					<input type="text" name="<?php echo $this->slider_name; ?>[title][]" value="<?php echo $item_title; ?>" />
				</td>
				<td>
					<textarea name="<?php echo $this->slider_name; ?>[caption][]"><?php echo stripslashes(htmlspecialchars($item_caption));?></textarea>
				</td>
				<td>
					<input title="<?php echo $this->slider_name;?>" type="button" class="button add-slider-above" value="افزودن به بالا" /><br />
					<input type="button" class="button-primary delete-slider-item" value="حذف" /><br />
					<input title="<?php echo $this->slider_name;?>" type="button" class="button add-slider-below" value="افزودن به پایین" /><br />
				</td>
			</tr>
<?php
		endforeach;
		}
?>
		</tbody>
	</table>

	<input type="submit" class="button" id="final_submit" name="final_submit" value="ذخیره تنظیمات" />
</form>
<?php
	
	}
	
	
	function save_options(){

		if (isset($_POST['action']) && $_POST['action'] == 'tsweb_save_slider' ) {
							$posted_slider=$_POST[$this->slider_name];
							$posted_images=$posted_slider['image'];
							$posted_links=$posted_slider['link'];
							$posted_titles=$posted_slider['title'];
							$posted_captions=$posted_slider['caption'];
							update_option($this->image_name, $posted_images);
							update_option($this->link_name, $posted_links);
							update_option($this->title_name, $posted_titles);
							update_option($this->caption_name, $posted_captions);
				
					echo '<div id="message" class="updated fade"><p><strong>تنظیمات قالب '.TSWEB_THEME.' ذخیره شد.</strong></p></div>';
		}
	}
}//end class
?>